<?php
/**
 * Flatsome functions and definitions
 *
 * @package flatsome
 */
add_action('init', function () {
    remove_action('admin_notices', 'flatsome_status_check_admin_notice');
    remove_action('admin_notices', 'flatsome_maintenance_admin_notice');
    remove_filter('pre_set_site_transient_update_themes', 'flatsome_get_update_info', 1, 999999);
    remove_filter('pre_set_transient_update_themes', 'flatsome_get_update_info', 1, 999999);
});

$site_url = get_site_url();
$domain_name = wp_parse_url($site_url, PHP_URL_HOST);
$update_option_data = array(
    'id'           => '01234156789',
    'type'         => 'PUBLIC',
    'domain'       => $domain_name,
    'registeredAt' => '2024-01-01T12:51:10.826Z',
    'purchaseCode' => 'ZqihUGpp-MjNr-oKco-hRit-PbJXLeLwwAqW',
    'licenseType'  => 'Regular License',
    'errors'       => array(),
    'show_notice'  => false
);
update_option('flatsome_registration', $update_option_data, 'yes');
update_option( 'flatsome_wup_supported_until', '01.11.2025' );
update_option( 'flatsome_wup_buyer', 'themetot.com' );
require get_template_directory() . '/inc/init.php';

flatsome()->init();

/**
 * It's not recommended to add any custom code here. Please use a child theme
 * so that your customizations aren't lost during updates.
 *
 * Learn more here: https://developer.wordpress.org/themes/advanced-topics/child-themes/
 */

